SELECT
"public".geopoint.geopoint_guid,
"public".geopoint.longitude,
"public".geopoint.latitude,
"public".geopoint.bearing,
"public".geopoint.distance,
"public".geopoint.frompoint_guid,
"public".geopoint.user_entered_x,
"public".geopoint.user_entered_y,
"public".geopoint.pointno,
"public".geopoint.userinputformat,
"public".geopoint.coordformat,
"public".geopoint.coordrefsys,
"public".imsmaenum.enumvalue,
"public".geopoint.pointlocal_id
FROM
"public".geopoint
INNER JOIN "public".geospatialinfo ON "public".geospatialinfo.geospatialinfo_guid = "public".geopoint.geospatialinfo_guid
INNER JOIN "public".imsmaenum ON "public".imsmaenum.imsmaenum_guid = "public".geospatialinfo.shapeenum_guid
WHERE
("public".geopoint.distance IS NOT NULL AND
"public".geopoint.bearing IS NOT NULL) AND
"public".geopoint.frompoint_guid IS NULL AND
"public".geopoint.user_entered_x IS NOT NULL AND
"public".geopoint.user_entered_y IS NOT NULL AND
"public".geopoint.pointno <> 1 AND
"public".imsmaenum.enumvalue LIKE 'Poly%'
ORDER BY
"public".geopoint.geospatialinfo_guid ASC,
"public".geopoint.pointno ASC
